/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: MoreVxdWraps.h,v 1.3 1999/12/10 10:34:20 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_MoreVxdWraps_h	// [
#define Included_MoreVxdWraps_h

#include "pgpClassesConfig.h"

//// Align to 1.
#pragma pack(push, 1)


// Constants

#define	VXDINLINE	static __inline
#define	NAKED		__declspec(naked) _cdecl


// Types

typedef	PVMMMUTEX	MUTEXHANDLE;
typedef	UINT		SEMHANDLE;
typedef UINT		TIMERHANDLE;
typedef UINT		VMMHANDLE;

typedef struct	cb_s*	VMHANDLE;
typedef struct	cb_s**	PVMHANDLE;

struct VxdIntRegs
{
	UINT	eax;		// general register EAX
	UINT	ebx;		// general register EBX
	UINT	ecx;		// general register ECX
    UINT	edx;		// general register EDX
	UINT	edi;		// general register EDI
	UINT	esi;		// general register ESI

	UINT	flags;		// lower word of EFLAGS register
};


// IOS Wrappers

#define IOS_DEVICE_ID	0x0010
#define IOS_Service Declare_Service

#pragma warning(disable:4003)

Begin_Service_Table(IOS)

IOS_Service(IOS_Get_Version, LOCAL)
IOS_Service(IOS_BD_Register_Device)
IOS_Service(IOS_Find_Int13_Drive)
IOS_Service(IOS_Get_Device_List)
IOS_Service(IOS_SendCommand)
IOS_Service(IOS_BD_Command_Complete)
IOS_Service(IOS_Synchronous_Command)
IOS_Service(IOS_Register)
IOS_Service(IOS_Requestor_Service)
IOS_Service(IOS_Exclusive_Access)
IOS_Service(IOS_Send_Next_Command)
IOS_Service(IOS_Set_Async_Time_Out)
IOS_Service(IOS_Signal_Semaphore_No_Switch)
IOS_Service(IOSIdleStatus)
IOS_Service(IOSMapIORSToI24)
IOS_Service(IOSMapIORSToI21)

End_Service_Table(IOS)

#pragma warning(default:4003)


VOID 
VXDINLINE 
IOS_SendCommand(PIOR pIor, PDCB pDcb)
{
	_asm mov esi, pIor
	_asm mov edi, pDcb
	VxDCall(IOS_SendCommand)
}

VOID 
VXDINLINE 
NAKED 
IOS_Requestor_Service(PIRS pIrs)
{
	_asm push pIrs
	VxDCall(IOS_Requestor_Service)
	_asm add esp, 4
}

VOID 
VXDINLINE 
IOS_Register(PDRP pDrp)
{
	_asm push pDrp
	VxDCall(IOS_Register)
	_asm add esp, 4
}

UINT 
VXDINLINE 
NAKED 
IOSMapIORSToI21(UINT iorErrorCode)
{
	VxDJmp(IOSMapIORSToI21);
}


// IFS Wrappers

#define IFSMgr_DEVICE_ID 0x0040

#define IFSMgr_Service Declare_Service
#pragma warning(disable:4003)	// not enough parameters

Begin_Service_Table(IFSMgr)

IFSMgr_Service(IFSMgr_Get_Version)
IFSMgr_Service(IFSMgr_RegisterMount)
IFSMgr_Service(IFSMgr_RegisterNet)
IFSMgr_Service(IFSMgr_RegisterMailSlot)
IFSMgr_Service(IFSMgr_Attach)
IFSMgr_Service(IFSMgr_Detach)
IFSMgr_Service(IFSMgr_Get_NetTime)
IFSMgr_Service(IFSMgr_Get_DOSTime)
IFSMgr_Service(IFSMgr_SetupConnection)
IFSMgr_Service(IFSMgr_DerefConnection)
IFSMgr_Service(IFSMgr_ServerDOSCall)
IFSMgr_Service(IFSMgr_CompleteAsync)
IFSMgr_Service(IFSMgr_RegisterHeap)
IFSMgr_Service(IFSMgr_GetHeap)
IFSMgr_Service(IFSMgr_RetHeap)
IFSMgr_Service(IFSMgr_CheckHeap)
IFSMgr_Service(IFSMgr_CheckHeapItem)
IFSMgr_Service(IFSMgr_FillHeapSpare)
IFSMgr_Service(IFSMgr_Block)
IFSMgr_Service(IFSMgr_Wakeup)
IFSMgr_Service(IFSMgr_Yield)
IFSMgr_Service(IFSMgr_SchedEvent)
IFSMgr_Service(IFSMgr_QueueEvent)
IFSMgr_Service(IFSMgr_KillEvent)
IFSMgr_Service(IFSMgr_FreeIOReq)
IFSMgr_Service(IFSMgr_MakeMailSlot)
IFSMgr_Service(IFSMgr_DeleteMailSlot)
IFSMgr_Service(IFSMgr_WriteMailSlot)
IFSMgr_Service(IFSMgr_PopUp)
IFSMgr_Service(IFSMgr_printf)
IFSMgr_Service(IFSMgr_AssertFailed)
IFSMgr_Service(IFSMgr_LogEntry)
IFSMgr_Service(IFSMgr_DebugMenu)
IFSMgr_Service(IFSMgr_DebugVars)
IFSMgr_Service(IFSMgr_GetDebugString)
IFSMgr_Service(IFSMgr_GetDebugHexNum)
IFSMgr_Service(IFSMgr_NetFunction)
IFSMgr_Service(IFSMgr_DoDelAllUses)
IFSMgr_Service(IFSMgr_SetErrString)
IFSMgr_Service(IFSMgr_GetErrString)
IFSMgr_Service(IFSMgr_SetReqHook)
IFSMgr_Service(IFSMgr_SetPathHook)
IFSMgr_Service(IFSMgr_UseAdd)
IFSMgr_Service(IFSMgr_UseDel)
IFSMgr_Service(IFSMgr_InitUseAdd)
IFSMgr_Service(IFSMgr_ChangeDir)
IFSMgr_Service(IFSMgr_DelAllUses)
IFSMgr_Service(IFSMgr_CDROM_Attach)
IFSMgr_Service(IFSMgr_CDROM_Detach)
IFSMgr_Service(IFSMgr_Win32DupHandle)
IFSMgr_Service(IFSMgr_Ring0_FileIO)
IFSMgr_Service(IFSMgr_Win32_Get_Ring0_Handle)
IFSMgr_Service(IFSMgr_Get_Drive_Info)
IFSMgr_Service(IFSMgr_Ring0GetDriveInfo)
IFSMgr_Service(IFSMgr_BlockNoEvents)
IFSMgr_Service(IFSMgr_NetToDosTime)
IFSMgr_Service(IFSMgr_DosToNetTime)
IFSMgr_Service(IFSMgr_DosToWin32Time)
IFSMgr_Service(IFSMgr_Win32ToDosTime)
IFSMgr_Service(IFSMgr_NetToWin32Time)
IFSMgr_Service(IFSMgr_Win32ToNetTime)
IFSMgr_Service(IFSMgr_MetaMatch)
IFSMgr_Service(IFSMgr_TransMatch)
IFSMgr_Service(IFSMgr_CallProvider)
IFSMgr_Service(UniToBCS)
IFSMgr_Service(UniToBCSPath)
IFSMgr_Service(BCSToUni)
IFSMgr_Service(UniToUpper)
IFSMgr_Service(UniCharToOEM)
IFSMgr_Service(CreateBasis)
IFSMgr_Service(MatchBasisName)
IFSMgr_Service(AppendBasisTail)
IFSMgr_Service(FcbToShort)
IFSMgr_Service(ShortToFcb)
IFSMgr_Service(IFSMgr_ParsePath)
IFSMgr_Service(Query_PhysLock)
IFSMgr_Service(_VolFlush)
IFSMgr_Service(NotifyVolumeArrival)
IFSMgr_Service(NotifyVolumeRemoval)
IFSMgr_Service(QueryVolumeRemoval)
IFSMgr_Service(IFSMgr_FSDUnmountCFSD)
IFSMgr_Service(IFSMgr_GetConversionTablePtrs)
IFSMgr_Service(IFSMgr_CheckAccessConflict)
IFSMgr_Service(IFSMgr_LockFile)
IFSMgr_Service(IFSMgr_UnlockFile)
IFSMgr_Service(IFSMgr_RemoveLocks)
IFSMgr_Service(IFSMgr_CheckLocks)
IFSMgr_Service(IFSMgr_CountLocks)
IFSMgr_Service(IFSMgr_ReassignLockFileInst)
IFSMgr_Service(IFSMgr_UnassignLockList)
IFSMgr_Service(IFSMgr_MountChildVolume)
IFSMgr_Service(IFSMgr_UnmountChildVolume)
IFSMgr_Service(IFSMgr_SwapDrives)
IFSMgr_Service(IFSMgr_FSDMapFHtoIOREQ)
IFSMgr_Service(IFSMgr_FSDParsePath)
IFSMgr_Service(IFSMgr_FSDAttachSFT)
IFSMgr_Service(IFSMgr_GetTimeZoneBias)
IFSMgr_Service(IFSMgr_PNPEvent)
IFSMgr_Service(IFSMgr_RegisterCFSD)
IFSMgr_Service(IFSMgr_Win32MapExtendedHandleToSFT)
IFSMgr_Service(IFSMgr_DbgSetFileHandleLimit)
IFSMgr_Service(IFSMgr_Win32MapSFTToExtendedHandle)
IFSMgr_Service(IFSMgr_FSDGetCurrentDrive)
IFSMgr_Service(IFSMgr_InstallFileSystemApiHook)
IFSMgr_Service(IFSMgr_RemoveFileSystemApiHook)
IFSMgr_Service(IFSMgr_RunScheduledEvents)
IFSMgr_Service(IFSMgr_CheckDelResource)
IFSMgr_Service(IFSMgr_Win32GetVMCurdir)
IFSMgr_Service(IFSMgr_SetupFailedConnection)
IFSMgr_Service(_GetMappedErr)
IFSMgr_Service(ShortToLossyFcb)
IFSMgr_Service(IFSMgr_GetLockState)
IFSMgr_Service(BcsToBcs)
IFSMgr_Service(IFSMgr_SetLoopback)
IFSMgr_Service(IFSMgr_ClearLoopback)
IFSMgr_Service(IFSMgr_ParseOneElement)
IFSMgr_Service(BcsToBcsUpper)

End_Service_Table(IFSMgr)

#pragma warning(default:4003)

DWORD 
VXDINLINE 
NAKED 
IFSMgr_Get_NetTime(DWORD &msRemaining)
{
	_asm
	{
		VxDJmp(IFSMgr_Get_NetTime)
		mov	msRemaining, edx
	}
}

USHORT 
VXDINLINE 
R0_OpenCreateFile(
	BOOL		isInContext, 
	const char	*path, 
	USHORT		mode, 
	USHORT		createAttribs, 
	BYTE		action, 
	BYTE		flags, 
	HANDLE		*pHandle, 
	BYTE		*pAction)
{
	UINT	opcode	= isInContext ? R0_OPENCREAT_IN_CONTEXT : 
		R0_OPENCREATFILE;
	USHORT	result;

	_asm
	{
		mov	eax, opcode
		mov bx, mode
		mov cx, createAttribs
		mov dl, action
		mov dh, flags
		mov esi, path
	}

	VxDCall(IFSMgr_Ring0_FileIO)

	_asm
	{
		jc	error
		mov ebx, pHandle
		mov [ebx], eax
		mov ebx, pAction
		mov [ebx], ecx
		xor eax, eax
		
	error:
		mov	result, ax
	}

	return result;
}

USHORT 
VXDINLINE 
R0_ReadFile(
	BOOL	isInContext, 
	HANDLE	handle, 
	PVOID	buffer, 
	UINT	count, 
	UINT	fileOffset, 
	UINT	*pBytesRead)
{
	UINT	opcode	= isInContext ? R0_READFILE_IN_CONTEXT : R0_READFILE;
	USHORT	result;

	_asm
	{
		mov	eax, opcode
		mov	ebx, handle
		mov ecx, count
		mov edx, fileOffset
		mov esi, buffer
	}

	VxDCall(IFSMgr_Ring0_FileIO)
	
	_asm
	{
		jc	error
		mov ebx, pBytesRead
		mov [ebx], ecx
		xor eax, eax
	error:
		mov	result, ax
	}

	return result;
}

USHORT 
VXDINLINE 
R0_WriteFile(
	BOOL	isInContext, 
	HANDLE	handle, 
	PVOID	buffer, 
	UINT	count, 
	UINT	fileOffset, 
	UINT	*pBytesWritten)
{
	UINT	opcode	= isInContext ? R0_WRITEFILE_IN_CONTEXT : R0_WRITEFILE;
	USHORT	result;

	_asm
	{
		mov	eax, opcode
		mov	ebx, handle
		mov ecx, count
		mov edx, fileOffset
		mov esi, buffer
	}

	VxDCall(IFSMgr_Ring0_FileIO)
	
	_asm
	{
		jc	error
		mov ebx, pBytesWritten
		mov [ebx], ecx
		xor eax, eax
	error:
		mov	result, ax
	}

	return result;
}

USHORT 
VXDINLINE 
R0_CloseFile(HANDLE handle)
{
	USHORT	result;

	_asm
	{
		mov	eax, R0_CLOSEFILE
		mov ebx, handle
	}

	VxDCall(IFSMgr_Ring0_FileIO)

	_asm
	{
		jc error
		xor eax, eax
	error:
		mov result, ax
	}

	return result;
}

USHORT 
VXDINLINE 
R0_GetFileSize(HANDLE handle, UINT *pSize)
{
	USHORT	result;

	_asm
	{
		mov	eax, R0_GETFILESIZE
		mov ebx, handle
	}

	VxDCall(IFSMgr_Ring0_FileIO)

	_asm
	{
		jc	error
		mov ebx, pSize
		mov [ebx], eax
		xor	eax, eax
	error:
		mov result, ax
	}

	return result;
}

UINT 
VXDINLINE 
NAKED 
_VolFlush(UINT drive, UINT flags)
{
	VxDJmp(_VolFlush)
}

ppIFSFileHookFunc 
VXDINLINE 
NAKED 
IFSMgr_InstallFileSystemApiHook(pIFSFileHookFunc fcn)
{
	VxDJmp(IFSMgr_InstallFileSystemApiHook)
}

UINT 
VXDINLINE 
NAKED 
IFSMgr_RemoveFileSystemApiHook(pIFSFileHookFunc fcn)
{
	VxDJmp(IFSMgr_RemoveFileSystemApiHook)
}

UINT 
VXDINLINE 
NAKED 
IFSMgr_GetLockState(
	UINT	drive, 
	UINT	*pLockType, 
	UINT	*pLockFlags, 
	UINT	*pLockOwner)
{
	VxDJmp(IFSMgr_GetLockState)
}

VOID 
VXDINLINE 
NAKED 
NotifyVolumeRemoval(UINT drive)
{
	VxDJmp(NotifyVolumeRemoval)
}


// Callback-related wrappers

typedef void (_cdecl *GlobalTimeoutCallbackType)(VMHANDLE hVM, 
	Client_Reg_Struc *pRegs, PVOID refData, DWORD tardiness);

typedef void (_cdecl *RestrictedEventCallbackType)(VMHANDLE hVM, 
	Client_Reg_Struc *pRegs, PVOID refData, DWORD threadHandle);

struct GlobalTimeoutThunk
{
	GlobalTimeoutCallbackType	callback;
	void	*refData;
};

struct RestrictedEventThunk
{
	RestrictedEventCallbackType	callback;
	void	*refData;
};

void _cdecl	_GlobalTimeoutCallback();
void _cdecl	_RestrictedEventCallback();

TIMERHANDLE 
VXDINLINE 
PGPdisk_Set_Global_Timeout(
	CMS							cms, 
	void						*refData, 
	GlobalTimeoutCallbackType	callback, 
	GlobalTimeoutThunk&			thunk)
{
	thunk.callback = callback;
	thunk.refData = refData;

	return Set_Global_Time_Out(_GlobalTimeoutCallback, cms, 
		reinterpret_cast<ULONG>(&thunk));
}

VMMEVENT 
VXDINLINE 
PGPdisk_Call_Restricted_Event(
	ULONG						ulBoost, 
	HVM							hwm, 
	ULONG						flags, 
	void						*refData, 
	CMS							cms, 
	RestrictedEventCallbackType	callback, 
	RestrictedEventThunk&		thunk)
{
	thunk.callback = callback;
	thunk.refData = refData;

	return Call_Restricted_Event(ulBoost, hwm, flags, 
		reinterpret_cast<ULONG>(&thunk), _RestrictedEventCallback, cms);
}


// Miscellaneous wrappers

void 
Exec_VxD_Int(UINT interrupt, VxdIntRegs *pRegs);

inline 
void *  
Map16BitAddrToLinear(USHORT segment, USHORT offset)
{
	VMHANDLE	hVm	=	reinterpret_cast<VMHANDLE>(Get_Cur_VM_Handle());

	return static_cast<void *>(
		reinterpret_cast<PBYTE>(hVm->CB_High_Linear) + 
		(segment << 4) + offset);
}

UINT 
VXDINLINE 
NAKED 
Get_System_Time()
{
	VMMJmp(Get_System_Time);
}

typedef void (_cdecl *Ring0ThreadFuncType)(DWORD);

HANDLE 
VXDINLINE 
_VWIN32_CreateRing0Thread(
	UINT				stackSize, 
	UINT				refData, 
	Ring0ThreadFuncType	callback, 
	Ring0ThreadFuncType	failureFunc, 
	HANDLE&				ring3Handle)
{
	HANDLE	ring0Handle;

	_asm
	{
		mov	ecx, stackSize
		mov	edx, refData
		mov	ebx, callback
		mov esi, failureFunc

		VxDCall(_VWIN32_CreateRing0Thread)

		mov	ring3Handle, eax
		mov	ring0Handle, edx
	}

	return ring0Handle;
}

// Restore alignment.
#pragma pack(pop)

#endif	// ] Included_MoreVxdWraps_h
